import { Factory, faker} from 'ember-cli-mirage';

/**
 * Example URL: GET /api/users/:user/followed/hosting?limit=40&offset=0
 */
export default Factory.extend({
  _id(i) {
    return i;
  },

  name: faker.internet.userName(),
  logo: faker.internet.avatar(),
  display_name() {
    return this.name;
  },

  _links() {
    return {
      self: `https://api.twitch.tv/api/users/${this.name}/followed/hosting?limit=40&offset=0`,
      next: `https://api.twitch.tv/api/users/${this.name}/followed/hosting?limit=40&offset=40`
    };
  }
});
