import { Factory } from 'ember-cli-mirage';
import getServer from '../get-server';

/**
 * A "stream object" representing a live stream.
 * This json payload is embedded in the response to:
 *   `GET /streams/:channel/`
 * as the `stream` property (see `factories/channel-stream.js` for the full
 * response), and in the response to
 *   `GET /streams`
 * as an item in the `streams` array property.
 *
 * It is not ever returned directly from an API call.
 */
export default Factory.extend({
  _id(i) {
    return i;
  },

  name(i) {
    return `twitch${i}`;
  },

  game: "Gaming Talk Shows",
  viewers: 238,
  created_at: "2016-02-24T22:37:43Z",
  video_height: 720,
  average_fps: 59.9496221662,
  delay: 0,
  is_playlist: false,
  is_featured: false,
  _platform: null, // can be ps4 or xbox
  _links() {
    return {
      "self":`https://api.twitch.tv/kraken/streams/${this.name}`
    };
  },
  preview() {
    return getServer().create('stream-preview');
  },
  channel() {
    return getServer().create('channel', {
      _id: this._id,
      name: this.name,
      game: this.game
    });
  }
});
