import { Factory, faker } from 'ember-cli-mirage';

// This factory only differs from `stream` in the naming of a few attributes, due to API endpoint inconsistency.
// We should move toward consolidating these, since they represent the same thing.
export default Factory.extend({
  _id(i) {
    return i;
  },
  id: faker.internet.userName(),
  meta_game: "Final Fantasy VII",
  preview: faker.image.imageUrl(),
  title: faker.lorem.sentence(),
  url() {
    return `https://www.twitch.tv/${this.id}`;
  },
  viewers: 1086
});
