import { Factory } from 'ember-cli-mirage';
import { JTV_USER_PICTURES_404_USER_150X150_URL } from 'web-client/utilities/urls/static-cdn';
import { USER_TYPE_STAFF } from 'web-client/utilities/user';

export default Factory.extend({
  _id(i) {
    // Some code interprets ID 0 as false (incorrectly) so we start at 1
    return i + 1;
  },
  _links() {
    return {
      self: `https://api.twitch.tv/kraken/users/${this.name}`
    };
  },
  bio: null,
  created_at: '2016-03-08T17:34:22Z',
  display_name() { return this.name; },
  displayName() { return this.name; },
  login() { return this.name; },
  logo: JTV_USER_PICTURES_404_USER_150X150_URL,
  name: 'twitch',
  profile_banner: null,
  profile_banner_background_color: null,
  updated_at: '2016-07-13T18:55:41Z',

  // Current User only properties
  email: 'twitch@twitch.tv',
  notifications: {
    push: false,
    email: true
  },
  partnered: true,
  type: USER_TYPE_STAFF
});
