import { Factory } from 'ember-cli-mirage';
import { ARCHIVE_TYPE_PARAM } from 'web-client/utilities/video/types';

/**
 * An archived video, highlight, or upload.
 */
export default Factory.extend({
  _id(i) { return `v${i + 1}`; },

  // Use a different number for broadcast ID so we don't mistakenly use the
  // wrong ID in tests.
  broadcast_id(i) { return i + 1000; },
  channel: {
    name: 'twitch',
    display_name: 'Twitch'
  },

  //TODO: audit and remove
  name: 'twitch',

  // type could be 'highlight'
  broadcast_type: ARCHIVE_TYPE_PARAM,
  is_muted: false,
  length: 60,
  preview: '',
  published_at: '2016-03-18T00:18:49Z',
  recorded_at: '2016-03-18T00:18:49Z',
  status: 'recorded',
  title(i) { return `Broadcast ${i}`; },
  tag_list: '',
  views: 0,
  url() {
    return `/v/${this.id}`;
  },
  created_at(i) { return new Date() + i; },
  description_html(i) { return `video ${i} description`; }
});
