export default function(server, namespace = 'http://api.twitch.tv/bits') {
  server.namespace = namespace;

  server.get('/users/:id', function ({ bitsSenderEligibilities }, request) {
    let { id } = request.params;
    let eligibility = bitsSenderEligibilities.first({ channelId: id });
    return eligibility.attrs;
  });

  server.get('/channels/:id', function ({ bitsRecipientEligibilities }, request) {
    let { id } = request.params;
    let eligibility = bitsRecipientEligibilities.first({ channelId: id });

    return eligibility.attrs;
  });

  server.get('/channels/:id/settings', function ({ bitsChannelSettings }, request) {
    let { id } = request.params;
    let channelSettings = bitsChannelSettings.first({ channelId: id });
    return channelSettings.attrs;
  });

  server.get('/badges/:id/tiers', function ({ bitsBadgeTiers }, request) {
    let { id } = request.params;
    let badgeTiers = bitsBadgeTiers.first({ channelId: id });
    return badgeTiers.attrs;
  });

  server.get('/balance/:id', function ({ bitsBalances }, request) {
    let { id } = request.params;
    let balance = bitsBalances.first({ channelId: id });

    return balance.attrs;
  });

  server.post('/events', function ({ bitsBalances, bitsTransactions }, request) {
    let params = JSON.parse(request.requestBody);
    let newTransaction = bitsTransactions.create(params);

    // update bitsBalance with new bitsBalance
    let senderBalance = bitsBalances.first({ channelId: params.sender });
    let balance = senderBalance.attrs.balance - params.amount;
    senderBalance.update('balance', balance);

    return { balance, transaction_id: newTransaction.attrs.id };
  });

  server.get('/prices', () => {
    return { prices: [] };
  });

  server.namespace = null;
}
