import Mirage from 'ember-cli-mirage';
export default function(server, namespace = 'http://api.twitch.tv/v5') {
  server.namespace = namespace;

  let game = function ({ gameDetails }, request) {
    let { gameId } = request.params;
    let detail = gameDetails.first({ mirageId: gameId});
    if (detail) {
      return detail.attrs;
    }
    return new Mirage.Response(404);
  };

  server.get('/games/:gameId/details', game);
  server.get('/games/:gameId/details/user', game);

  server.namespace = null;
}
