import Mirage from 'ember-cli-mirage';

export default function (server, namespace = 'http://api.twitch.tv/v5') {
  server.namespace = namespace;

  server.get('connections/vhs/:service', (schema, request) => {
    let oauth = request.requestHeaders.Authorization;
    if (oauth === 'OAuth connected') {
      return new Mirage.Response(204, {});
    }

    return new Mirage.Response(404, {}, {
      status: 404,
      error: 'Not Found',
      message: `User is not connected to "${request.params.service}"`
    });
  });

  server.namespace = undefined;
}
