import Mirage from 'ember-cli-mirage';

export default function (server, namespace = `http://api.twitch.tv/v5`) {
  server.namespace = namespace;

  server.get('/emailvalidator/:opaque_id', (schema, { params }) => {
    if (params.opaque_id === "success") {
      return new Mirage.Response(204, {});
    }

    return new Mirage.Response(404, {}, {
      status: 404,
      error: 'Not Found',
      message: "404: Email validation result not found"
    });

  });

  server.namespace = undefined;
}
