import { EMS_API_VERSION } from 'web-client/adapters/extension';
import { Response } from 'ember-cli-mirage';

export default function (server, namespace = `https://api.twitch.tv/v${EMS_API_VERSION}`) {
  server.namespace = namespace;

  server.get('/extensions', (schema) => {
    let extensions = schema.extensions.all().models;
    return {
      extensions
    };
  });

  server.get('/extensions/:extensionId/:version', ({ extensions }, { params }) => {
    let id = params.extensionId;
    let version = params.version;
    return extensions.first({ id, version });
  });

  server.get('/channels/:channelId/extensions', ({ extensionInstallations }, { params }) => {
    let channelId = params.channelId;
    let installations = extensionInstallations.where({ channelId }).models;
    let result = {
      extensions: installations.map(ext => ext.extension),
      actives: installations.filter(ext => ext.active).map(ext => {
        return {
          extension_id: ext.extension.id,
          active: true,
          config: JSON.stringify(ext.config)
        };
      }),
      tokens: installations.filter(ext => !!ext.token).map(ext => {
        return {
          extension_id: ext.extension.id,
          token: ext.token
        };
      })
    };

    return result;
  });

  server.post('/channels/:channelId/extensions/:extensionId/:version', ({ extensions, extensionInstallations }, { params }) => {
    let id = params.extensionId;
    let version = params.version;
    let channelId = params.channelId;
    let extension = extensions.first({ id, version });

    if (!extension) {
      return new Response(404, {}, {
        error: 'Not Found',
        message: 'No extension found',
        status: 404
      });
    }

    extensionInstallations.create({ extension, channelId });

    return new Response(204, {}, {
      status: 204
    });
  });

  server.delete('/channels/:channelId/extensions/:extensionId/:version', ({ extensionInstallations }, { params }) => {
    let id = params.extensionId;
    let version = params.version;
    let channelId = params.channelId;
    let installations = extensionInstallations.where({ channelId }).models;
    let installation = installations.find(({ extension }) => extension.id === id && extension.version === version);

    if (!installation) {
      return new Response(404, {}, {
        error: 'Not Found',
        message: 'No extension found',
        status: 404
      });
    }

    installation.destroy();

    return new Response(204, {}, {
      status: 204
    });
  });

  server.put('/channels/:channelId/extensions/:extensionId/:version', ({ extensionInstallations }, { params, requestBody }) => {
    let id = params.extensionId;
    let version = params.version;
    let channelId = params.channelId;

    let installations = extensionInstallations.where({ channelId }).models;
    let installation = installations.find(({ extension }) => extension.id === id && extension.version === version);

    if (!installation) {
      return new Response(404, {}, {
        error: 'Not Found',
        message: 'No extension found',
        status: 404
      });
    }

    let payload = JSON.parse(requestBody);
    installation.update(payload);

    return new Response(204, {}, {
      status: 204
    });
  });

  server.namespace = undefined;
}
