import { parseQueryParams } from 'web-client/utilities/url-params';

export default function(server) {
  server.namespace = 'http://api.twitch.tv/kraken';

  server.get('/collections/:playlist_id', function({ videoPlaylists }, request) {
    let playlistId = request.params.playlist_id;
    let playlist = videoPlaylists.find(playlistId);

    let res = this.serialize(playlist);
    return res;
  });

  server.delete('/collections/:playlist_id', function({ videoPlaylists }, request) {
    let playlistId = request.params.playlist_id;
    videoPlaylists.remove(playlistId);
  });

  server.post('/collections/:playlist_id/items', function(schema, request) {
    let playlistId = request.params.playlist_id;
    let body = parseQueryParams(request.requestBody);
    body.playlist_id = playlistId;

    return schema.videoPlaylistItems.create(body);
  });

  server.get('/collections/:playlist_id/items', function(schema, request) {
    let playlistId = request.params.playlist_id;

    let items = schema.videoPlaylistItems.where({ playlistId });
    return { items: items.models };
  });

  server.put('/collections/:playlist_id/items/:item_id', function() {
    return;
  });

  server.namespace = undefined;
}
