import Ember from 'ember';
import serialize from '../utils/serialize';
import pageParams from '../utils/page-params';
const { merge } = Ember;

export default function(server, namespace = 'http://api.twitch.tv/kraken') {
  server.namespace = namespace;

  server.get('/streams', function (schema, request) {
    let _platform = null;
    if (request.queryParams.sce_platform === 'PS4') {
      _platform = 'ps4';
    } else if (request.queryParams.xbox_heartbeat === 'true') {
      _platform = 'xbox';
    }

    let whereParams = {is_featured: false};
    if (_platform) { whereParams._platform = _platform; }

    let streams = schema.streams.where(whereParams);
    let serialized = serialize(server, streams);
    let { offset, limit } = pageParams(request);
    if (limit) {
      serialized.streams = serialized.streams.slice(offset, offset + limit);
    }

    return merge(serialized, {
      _links: {
        self: "https://api.twitch.tv/kraken/streams?broadcaster_language=&game=Hearthstone",
        next: "https://api.twitch.tv/kraken/streams?broadcaster_language=&game=Hearthstone&limit=2&offset=2",
        featured: "https://api.twitch.tv/kraken/streams/featured",
        summary: "https://api.twitch.tv/kraken/streams/summary",
        followed: "https://api.twitch.tv/kraken/streams/followed"
      }
    });
  });

  server.get('/streams/followed', function (schema, request) {
    let { offset, limit } = pageParams(request);
    let follows = schema.follows.all();
    let _total = follows.models.length;
    let channelNames = follows.models.map(follow => follow.channel.name);
    let streams = channelNames.map(name => schema.streams.where({ name }).models[0]).compact();
    streams = streams.slice(offset, offset + limit);
    let serialized = streams.map(stream => serialize(server, stream).stream);

    return {
      streams: serialized,
      _total,
      _links: {
        self: `https://api.twitch.tv/kraken/streams/followed?limit=${limit}&offset=${offset}`,
        next: `https://api.twitch.tv/kraken/streams/followed?limit=${limit}&offset=${offset + limit}`
      }
    };
  });

  server.get('streams/recent', function(schema) {
    return schema.recentlyWatchedStreams.find(1);
  });

  server.get('/streams/:channel', function (schema, request) {
    let channel = schema.db.channelStreams.where({ name: request.params.channel })[0];
    return channel;
  });

  server.post('/streams/watch-now', function(schema) {
    let recs = schema.follows.all().models.map((follow) => {
      return {
        recommendation: {
          reason: "following",
          data: null
        },
        stream: {
          channel: {
            display_name: follow.channel.display_name,
            game: 'Some Game',
            url: `https://www.twitch.tv/${follow.channel.name}`
          },
          viewers: 230,
          is_playlist: false
        }
      };
    });
    recs.push({
      recommendation: {
        reason: "partner",
        data: null
      },
      stream: {
        channel: {
          display_name: 'Partner',
          game: 'Some Game',
          url: 'https://www.twitch.tv/partner'
        },
        viewers: 432,
        is_playlist: false
      }
    });
    return {
      recommendations: recs
    };
  });

  server.namespace = undefined;
}
