import { VERSION } from 'web-client/services/subscriptions';

export default function (server, namespace = `https://api.twitch.tv/subscriptions/v${VERSION}`) {
  server.namespace = namespace;

  server.get('/channels/:channel_id/badges', () => {
    let badges = [
      {
        id: 12345,
        required_tenure_months: 6,
        image_1x_url: '#',
        image_2x_url: '#',
        image_4x_url: '#',
        title: '6-Month Subscriber'
      },
      {
        id: 9000,
        required_tenure_months: 24,
        image_1x_url: '#',
        image_2x_url: '#',
        image_4x_url: '#',
        title: '2-Year Subscriber'
      }
    ];

    return badges;
  });

  server.post('/channels/:channel_id/badges', () => {
    let createdBadge = {
      id: 1,
      required_tenure_months: 0,
      image_1x_url: '#',
      image_2x_url: '#',
      image_4x_url: '#',
      title: 'Subscriber'
    };

    return createdBadge;
  });

  server.delete('/channels/:channel_id/badges/:badge_id', () => {
    let deletedBadge = {
      id: 1,
      required_tenure_months: 0
    };

    return deletedBadge;
  });

  server.get('/channels/:channel_id/timeout_statuses', () => {
    let timeoutStatuses = {
      badges_timed_out: false
    };

    return timeoutStatuses;
  });

  server.namespace = null;
}
