import { getTimeSeriesData } from 'web-client/mirage/fixtures/video-stats-timeseries';

export default function(server, namespace = 'https://api.twitch.tv/kraken') {
  server.namespace = namespace;

  server.get('/channels/:id/analytics/lifetime', (_, request) => {
    return {
      channel: request.params.id,
      analytics: LIFETIME_DATA
    };
  });

  server.get('/channels/:id/analytics', (_, request) => {
    return {
      channel: request.params.id,
      end_time: "2016-09-06T19:45:52.640834768Z",
      limit: 100,
      analytics: getTimeSeriesData()
    };
  });

  server.get('/vods/:id/analytics/lifetime', (_, request) => {
    return {
      video_id: request.params.id,
      end_time: "2016-09-06T19:45:52.640834768Z",
      limit: 100,
      analytics: LIFETIME_DATA
    };
  });

  server.get('/vods/:id/analytics', (_, request) => {
    return {
      video_id: request.params.id,
      end_time: "2016-09-06T19:45:52.640834768Z",
      limit: 100,
      analytics: getTimeSeriesData()
    };
  });
}

const LIFETIME_DATA = [
    {
      metric: "viewcount",
      metric_data: 30,
      filter_data: {
        country: { USA: 30 },
        platform: {},
        referer: { Twitter: 10}
      }
    }, {
      metric: "minuteswatched",
      metric_data: 450,
      filter_data: {
        country: { Canada: 450 },
        platform: {},
        referer: {}
      }
    }, {
      metric: "averageviewduration",
      metric_data: 15,
      filter_data: {
        country: { USA: 10, Canada: 5 },
        platform: { Mobile: 20 },
        referer: {}
      }
    }
];
