import channelScenario from './channel';

export const channelNames = [ 'webclienttest1', 'webclienttest2' ];

export default function (server) {
  channelScenario(server, channelNames[0], { game: 'Creative' });
  channelScenario(server, channelNames[1], { game: 'Creative' });
  server.createList('featured-stream', 2, {
    name(i) { return `featured${i}`; }
  });

  server.createList('stream', 1, {
    name(i) { return `xbox-${i}`; },
    _platform: 'xbox'
  });

  server.createList('stream', 3, {
    name(i) { return `ps4-${i}`; },
    _platform: 'ps4'
  });
}
