import bitsScenario from './bits';
import serialize from '../utils/serialize';
import { assert } from 'ember-metal/utils';

export default function (server, channelName = 'twitch', streamParams = {}, bitsOverrides) {
  assert('Must specify a valid channelName for scenario', channelName && channelName.length > 0);

  let channelChatProperties = server.create('channel-chat-properties');

  server.create('channel-ember-data', {
    _id: channelChatProperties._id,
    name: channelName
  });

  server.create('channel-chat-badges', {
    name: channelName
  });

  streamParams.name = channelName;
  let stream = server.create('stream', streamParams);

  server.create('channel-stream', {
    name: channelName,
    _id: channelChatProperties._id,
    stream: serialize(server, stream).stream
  });

  server.create('user', {
    type: 'user',
    name: channelName,
    _id: channelChatProperties._id
  });

  server.create('friendship-user', {
    login: channelName,
    id: channelChatProperties._id
  });

  bitsScenario(server, channelChatProperties._id, bitsOverrides);

  return server.schema.channels.where({ name: channelName }).models[0];
}
