function updateGameDetailName(server, gameDetail, gameName) {
  gameDetail.attrs.mirage_id = gameName;
  gameDetail.attrs.product.game_id = gameName;
  gameDetail.attrs.product.title = gameName;
  server.schema.db.gameDetails.update(gameDetail.attrs);
}

export default function(server, gameName) {

  let gameDetail = server.create('game-detail');
  updateGameDetailName(server, gameDetail, gameName);

  return gameDetail;
}

export function gameNoLongerForSaleScenario(server, gameName) {
  let gameDetail = server.create('game-detail', 'notForSale');
  updateGameDetailName(server, gameDetail, gameName);
  return gameDetail;
}

export function updateChannelWithGame(server, channel, gameName) {
  server.schema.db.channelEmberData.update(channel.id, {game: gameName});
}
