import bitsScenario from './bits';
import serialize from '../utils/serialize';
import Ember from 'ember';
const { merge } = Ember;

export default function(server, _options) {
  let options = merge({
    isOffline: false,
    isPlaylist: false,
    name: 'CounterPit',
    userName: 'twitch',
    game: 'Gaming Talk Shows'
  }, _options);

  let { name, game, userName } = options;

  let channel = options.channel;
  if (!channel) {
    let channelChatProperties = server.create('channel-chat-properties');
    server.create('channel-ember-data', {
      _id: channelChatProperties._id,
      name,
      game
    });
    server.create('channel-chat-badges', {
      name
    });

    if (options.isOffline) {
      channel = server.create('channel', {name, game});

      server.create('channel-stream', {
        name,
        game,
        _id: channelChatProperties._id,
        stream: null
      });
    } else {
      // is_playlist true indicates offline channel.
      let streamParams = {is_playlist: options.isPlaylist, name, game};

      let stream = server.create('stream', streamParams);

      server.create('channel-stream', {
        name,
        game,
        _id: channelChatProperties._id,
        stream: serialize(server, stream).stream
      });

      channel = server.schema.channels.where({name}).models[0];
    }

    server.create('user', {
      type: 'user',
      name,
      _id: channelChatProperties._id
    });

    server.create('friendship-user', {
      login: name,
      id: channelChatProperties._id
    });

    bitsScenario(server, channelChatProperties._id);
  }

  return server.create('follow', { channelName: name, userName, channel });
}
