import videoScenario from 'web-client/mirage/scenarios/video';
import { assign } from 'ember-platform';

export default function(server, _options) {
  let options = assign({
    releasesCount: 0,
    videosCount: 0,
    game: "League of Legends"
  }, _options);

  server.create('user', { _id: 12345 });
  let channel = server.create('channel', { _id: 12345 });

  for (let i=0; i<options.releasesCount; i++) {
    let scaffoldedVideos = [];
    for (let j=0; j<options.videosCount; j++) {
      let video = videoScenario(server, { channel });
      scaffoldedVideos.push(video);
    }
    server.create('game-new-release', {
      game: options.game,
      videos: scaffoldedVideos
    });
  }
}
