import channelScenario from './channel';

export default function(server) {
  // featured streams will also come back as live in testing since they have no platform
  let featuredStreams = server.createList('featured-stream', 6, {
    name(i) { return `live-${i}`; }
  });

  featuredStreams.forEach(stream => {
    channelScenario(server, stream.name);
  });

  server.createList('game', 12, {
    name(i) {
      return `game-${i}`;
    }
  });

  server.createList('featured-game', 2);


  // Create PS4 and xbox streams.
  // Create 7 of each so we can double check that only 6 show up on the page
  server.createList('stream', 7, {
    name(i) { return `ps4-${i}`; },
    _platform: 'ps4'
  });

  server.createList('stream', 7, {
    name(i) { return `xbox-${i}`; },
    _platform: 'xbox'
  });

  return { featuredStreams };
}
