import Ember from 'ember';

const { merge } = Ember;

export default function(server, _options) {
  let options = merge({
    available: false,
    channelsCount: 0,
    streamsCount: 0,
    availableResponseCode: 200,
    recommendedResponseCode: 200
  }, _options);
  server.get('https://api.twitch.tv/kraken/streams/recommended/available', { has_recommendations: options.available }, options.availableResponseCode);

  server.createList('recommended-stream', options.channelsCount, {_numRecs: options.streamsCount});

  server.get('https://api.twitch.tv/kraken/streams/recommended', function (schema) {
    let recs = schema.db.recommendedStreams;
    return {recommended_streams: recs};
  }, options.recommendedResponseCode);
}
