import videoScenario from 'web-client/mirage/scenarios/video';
import { assert } from 'ember-metal/utils';

export default function(server, playlistOptions = {}) {
  let owner = {
    id: playlistOptions.owner_id || 12345,
    name: playlistOptions.owner_login || 'login'
  };

  let itemCount = playlistOptions.itemCount || 1;
  delete playlistOptions.itemCount;

  let items = playlistOptions.items || [];
  delete playlistOptions.items;

  server.create('user', { _id: owner.id, login: owner.name });
  let channel = server.create('channel', { _id: owner.id });

  if (!Array.isArray(items)) {
    assert(`Expected 'items' array for playlistOptions, got: ${typeof items}`);
  }

  let playlist;
  if (playlistOptions.withItems) {
    playlist = server.create('video-playlist', 'withItems', { owner });

  } else {
    playlist = server.create('video-playlist', { owner });
  }

  if (items.length === 0) {
    let video = videoScenario(server, { channel });
    let playlistItems = server.createList('video-playlist-item', itemCount, {
      description_html: video.description_html,
      duration: video.duration,
      item_id: video.id,
      owner: {
        id: owner.id,
        name: owner.name
      },
      playlistId: playlist.id,
      thumbnail_url: video.preview,
      views: video.views
    });
    playlist.items = playlistItems;
  }

  return playlist;
}
