import { Serializer } from 'ember-cli-mirage';

export default Serializer.extend({
  serialize(modelOrCollection) {
    if (this.isCollection(modelOrCollection)) {
      return modelOrCollection.models.map(serializeSingle);
    }

    return serializeSingle(modelOrCollection);
  }
});

function serializeSingle(event) {
  return {
    _id: event.id,
    channel_id: event.channel._id,
    start_time: event.start_time,
    end_time: event.end_time,
    time_zone_id: event.time_zone_id,
    title: event.title,
    description: event.description,
    game_id: event.game && event.game._id,
    channel: event.channel.attrs,
    game: event.game && event.game.attrs
  };
}
