import { ActiveModelSerializer } from 'ember-cli-mirage';

export default ActiveModelSerializer.extend({
  serialize(model) {
    if (this.isCollection(model)) {
      return this.serializeCollection(model);
    }
    return this.serializeModel(model);
  },

  serializeCollection(collection) {
    return {
      recommendations: collection.models.map(m => this.serialize(m))
    };
  },

  serializeModel(model) {
    let user = {};
    let { recommendedReason } = model.attrs;

    Object.keys(model.attrs).forEach(key => {
      if (key !== 'recommendedReason') {
        user[key] = model.attrs[key];
      }
    });

    return {
      user,
      reason: recommendedReason
    };
  }
});
