import { ActiveModelSerializer } from 'ember-cli-mirage';

export default ActiveModelSerializer.extend({
  include: ['game'],
  embed: true,
  attrs: ['channels', 'viewers'],
  keyForCollection() {
    return 'follows';
  },

  serialize(model) {
    let serialized = ActiveModelSerializer.prototype.serialize.apply(this, arguments);
    if (this.isCollection(model)) {
      serialized._total = model.models.length;
    }
    return serialized;
  }
});
