import { ActiveModelSerializer } from 'ember-cli-mirage';

export default ActiveModelSerializer.extend({

  /*
   * This serializer is only appropriate for collections, and really
   * simply remaps the collection of video follows to a list of
   * serialized videos.
   */
  serialize(collection, request) {
    let videoSerializer = this.serializerFor('video');
    let videos = collection.models.map(collectionModel => {
      return videoSerializer.serialize(collectionModel.video, request);
    });

    return { videos };
  }
});
