import { test } from 'qunit';
import moduleForAcceptance from 'web-client/tests/helpers/module-for-acceptance';
import channelScenario from 'web-client/mirage/scenarios/channel';
import CollectionsPage from 'web-client/tests/pages/channel/playlists';
const CHANNEL_NAME = 'twitch';

moduleForAcceptance('Acceptance | Channel | Collections', {
  beforeEach() {
    channelScenario(this.server, CHANNEL_NAME);

    let channel = this.server.schema.findBy('user', { name: CHANNEL_NAME });

    this.broadcaster = {
      id: channel._id,
      login: channel.login,
      display_name: channel.login,
      channel_url: `https://www.twitch.tv/${CHANNEL_NAME}`
    };

    this.page = CollectionsPage.create({ name: CHANNEL_NAME });

    //See tests/acceptance/channel-redesign/clips-test.js
    $('#ember-testing').css({
      zoom: '100%'
    });
  },

  afterEach() {
    $('#ember-testing').css({
      zoom: ''
    });
  }
});

test('visiting the Collections page when the experiment is disabled', function (assert) {
  assert.expect(1);

  this.experiments.use({ PERPETUA: 'control' });

  visit(this.page.url());

  andThen(() => {
    assert.equal(currentURL(), `/${CHANNEL_NAME}`, 'redirects to the channel page');
  });
});

test('visiting the Collections page when the experiment is enabled', function (assert) {
  assert.expect(3);

  this.server.createList('video-playlist', 50, { owner_id: this.broadcaster.id, owner: { name: this.broadcaster.login, id: this.broadcaster.id } });

  this.experiments.use({ PERPETUA: 'early' });

  visit(this.page.url());

  andThen(() => {
    assert.equal(currentURL(), `/${CHANNEL_NAME}/collections`, 'successfully land on the Collections page');
    assert.elementCount(this.page.collections(), 20, 'renders collections from fixture data');
    this.page.scrollDown();
  });

  andThen(() => {
    assert.elementCount(this.page.collections(), 40, 'renders more collections after scroll');
  });
});
