import { test } from 'qunit';
import moduleForAcceptance from 'web-client/tests/helpers/module-for-acceptance';
import channelScenario from 'web-client/mirage/scenarios/channel';
import ChannelPage from 'web-client/tests/pages/channel/redesign';
import { stubLogin } from '../../helpers/stub-login';

const CHANNEL_NAME = 'twitch';

moduleForAcceptance('Acceptance | channel-redesign/extensions 1', {
  beforeEach() {
    let channel = channelScenario(this.server, CHANNEL_NAME);
    this.page = ChannelPage.create({ name: channel.name });
    this.experiments.use({ EXTENSIONS: 'yes' });
    stubLogin({ login: CHANNEL_NAME, is_staff: true });
  }
});

test('visiting channel page with extensions shows extensions on panels', function (assert) {
  assert.expect(2);
  visit(this.page.url());
  andThen(() => {
    click(find("li button:contains('Info')")[0]);
  });
  click('.edit-panels-toggle .switch');
  click('.js-new_panel_btn');
  andThen(() => {
    assert.equal(find("button :contains('Add a Text or Image Panel')").length, 1, 'Should find add text panel');
    assert.equal(find('.qa-extension-more-extensions').length, 1, 'Should find more extenions link');
  });
});

// The test for visiting a channel page when extensions are
// disabled is in extensions-2-test.js which had to be separated
// due to mysterious state leakage.

