import { test } from 'qunit';
import moduleForAcceptance from 'web-client/tests/helpers/module-for-acceptance';
import channelScenario from 'web-client/mirage/scenarios/channel';
import ChannelPage from 'web-client/tests/pages/channel/redesign';
import { stubLogin } from '../../helpers/stub-login';

const CHANNEL_ID = '0';
const CHANNEL_NAME = 'twitch';


// Zacksim: I initialliy tried to combine this test with extesions-test.js
// But there was a mysterious state leakage of the panels between
// tests and I found the only way I could stop that was to put them
// into separate acceptance test modules.

moduleForAcceptance('Acceptance | channel redesign/extensions 2', {
  beforeEach() {
    let channel = channelScenario(this.server, CHANNEL_NAME);
    this.page = ChannelPage.create({ name: channel.name });
  }
});

test('visiting channel page without extensions does not show extensions on panels', function (assert) {
  assert.expect(2);
  this.experiments.use({ EXTENSIONS: 'no' });
  stubLogin({ id: CHANNEL_ID, login: CHANNEL_NAME, is_staff: false });
  visit(this.page.url());
  andThen(() => {
    click(find("li button:contains('Info')")[0]);
  });
  click('.edit-panels-toggle .switch');
  click('.js-new_panel_btn');
  andThen(() => {
    assert.equal(find(".new-panel-form__label:contains('Panel Title:'):visible").length, 1);
    assert.equal(find("button :contains('Add a Text or Image Panel'):visible").length, 0);
  });
});

test('visiting channel page with extensions shows extensions on new panel', function(assert) {
  this.server.create('extension');
  assert.expect(1);
  this.server.create('extension-installation', { channelId: CHANNEL_ID });
  this.experiments.use({ EXTENSIONS: 'yes' });
  stubLogin({ id: CHANNEL_ID, login: CHANNEL_NAME, is_staff: true });
  visit(this.page.url());
  andThen(() => {
    click(find("li button:contains('Info')")[0]);
  });
  click('.edit-panels-toggle .switch');
  click('.js-new_panel_btn');
  andThen(() => {
    assert.equal(find('.extensions-name:visible').length, 1);
  });
});

