import { test } from 'qunit';
import moduleForAcceptance from 'web-client/tests/helpers/module-for-acceptance';
import channelScenario from 'web-client/mirage/scenarios/channel';
import ChannelPage from 'web-client/tests/pages/channel/redesign';
import { stubLogin } from '../../helpers/stub-login';

const CHANNEL_ID = '0';
const CHANNEL_NAME = 'twitch';

moduleForAcceptance('Acceptance | channel redesign/extensions 3', {
  beforeEach() {
    let channel = channelScenario(this.server, CHANNEL_NAME);
    this.page = ChannelPage.create({ name: channel.name });
  }
});

test('visiting channel page with extensions shows install extension panel', function(assert) {
  assert.expect(2);
  this.server.create('extension-installation', { channelId: CHANNEL_ID });
  this.experiments.use({ EXTENSIONS: 'yes' });
  stubLogin({ id: CHANNEL_ID, login: CHANNEL_NAME, is_staff: true });
  visit(this.page.url());
  andThen(() => {
    click(find("li button:contains('Info')")[0]);
  });
  // Enter edit mode
  click('.edit-panels-toggle .switch');
  click('.js-new_panel_btn');
  andThen(() => {
    // assert extension visible
    let extensionName = find('.extensions-name:visible');
    assert.equal(extensionName.length, 1);
    click(extensionName);
  });
  // Leave edit mode
  click('.edit-panels-toggle .switch');
  andThen(() => {
    let extensionPanel = find('.qa-panel-extension-name:visible');
    let installedExtension = this.server.schema.extensionInstallations.where({ channelId: CHANNEL_ID }).models[0];
    let extensionName = installedExtension.extension.name;
    assert.ok(extensionPanel.text().indexOf(extensionName) > 0, 'extension name needs to show');
  });
});
