import { test } from 'qunit';
import moduleForAcceptance from 'web-client/tests/helpers/module-for-acceptance';
import channelScenario from 'web-client/mirage/scenarios/channel';
import ChannelPage from 'web-client/tests/pages/channel/redesign';
import { stubLogin } from '../../helpers/stub-login';

const CHANNEL_NAME = 'twitch';

moduleForAcceptance('Acceptance | channel redesign/extensions 4', {
  beforeEach() {
    let channel = channelScenario(this.server, CHANNEL_NAME);
    this.page = ChannelPage.create({ name: channel.name });
  }
});

test('more extensions link works', function(assert) {
  assert.expect(1);
  this.experiments.use({ EXTENSIONS: 'yes' });
  stubLogin({ login: CHANNEL_NAME, is_staff: true });
  visit(this.page.url());
  andThen(() => {
    click(find("li button:contains('Info')")[0]);
  });
  // Enter edit mode
  click('.edit-panels-toggle .switch');
  click('.js-new_panel_btn');
  click('.qa-extension-more-extensions');
  andThen(() => {
    assert.equal(currentURL(), '/settings/extensions');
  });
});
