import { test } from 'qunit';
import moduleForAcceptance from 'web-client/tests/helpers/module-for-acceptance';
import channelScenario from 'web-client/mirage/scenarios/channel';
import videoScenario from 'web-client/mirage/scenarios/video';
import ChannelPage from 'web-client/tests/pages/channel/redesign';
import { ARCHIVE_TYPE_PARAM, HIGHLIGHT_TYPE_PARAM, UPLOAD_TYPE_PARAM } from 'web-client/utilities/video/types';
import { initializeChat } from 'web-client/tests/helpers/chat';

const CHANNEL_NAME = 'twitch';

moduleForAcceptance('Acceptance | channel-redesign/videos', {
  beforeEach() {
    this.page = ChannelPage.create({ name: CHANNEL_NAME });
    this.experiments.use({ CHANNEL_PAGE_REDESIGN: 'new'});

    this.channel = channelScenario(this.server, CHANNEL_NAME);
    this.highlight = videoScenario(this.server, { title: 'The Highlight', channel: this.channel, broadcast_type: HIGHLIGHT_TYPE_PARAM });
    this.pastBroadcast = videoScenario(this.server, { title: 'The Archive', channel: this.channel, broadcast_type: ARCHIVE_TYPE_PARAM });
  }
});

test('visiting channel videos page and filtering videos (with uploads)', function (assert) {
  assert.expect(10);

  this.upload = videoScenario(this.server, { title: 'The Upload', channel: this.channel, broadcast_type: UPLOAD_TYPE_PARAM });

  visit(`/${CHANNEL_NAME}/videos`);

  andThen(() => {
    assert.equal(currentURL(), `/${CHANNEL_NAME}/videos/all`, 'redirected to all');
    assert.equal(currentRouteName(), 'channel.videos.video-type');
    assert.elementCount(this.page.video(), 4, '4 videos');
    assert.elementCount(this.page.uploadCarouselVideo(), 1, '1 upload');
  });

  click(this.page.videoFilter());
  click(this.page.videoFilter('Uploads'));

  andThen(() => {
    assert.equal(currentURL(), `/${CHANNEL_NAME}/videos/uploads`, 'redirected to uploads');
    assert.elementCount(this.page.video(), 2, '2 filtered video');
    assert.elementCount(this.page.video('The Upload'), 2, 'uploaded video seen 2 times');
  });

  click(this.page.videoFilter());
  click(this.page.videoFilter('Past Broadcasts'));

  andThen(() => {
    assert.equal(currentURL(), `/${CHANNEL_NAME}/videos/past-broadcasts`, 'redirected to past-broadcasts');
    assert.elementCount(this.page.video(), 2, '2 filtered video');
    assert.elementCount(this.page.video('The Archive'), 1, 'selected video is a past broadcast');
  });
});

test('visiting channel videos page and filtering videos (without uploads)', function (assert) {
  assert.expect(11);

  visit(`/${CHANNEL_NAME}/videos`);

  andThen(() => {
    assert.equal(currentURL(), `/${CHANNEL_NAME}/videos/all`, 'redirected to all');
    assert.equal(currentRouteName(), 'channel.videos.video-type');
    assert.elementCount(this.page.video(), 2, '2 videos');
  });

  click(this.page.videoFilter());
  click(this.page.videoFilter('Past Broadcasts'));

  andThen(() => {
    assert.equal(currentURL(), `/${CHANNEL_NAME}/videos/past-broadcasts`, 'redirected to past-broadcasts');
    assert.elementCount(this.page.video(), 1, '1 filtered video');
    assert.elementCount(this.page.video('The Archive'), 1, 'selected video is a past broadcast');
  });

  click(this.page.videoFilter());
  click(this.page.videoFilter('Highlights'));

  andThen(() => {
    assert.equal(currentURL(), `/${CHANNEL_NAME}/videos/highlights`, 'redirected to highlights');
    assert.elementCount(this.page.video(), 1, '1 filtered video');
    assert.elementCount(this.page.video('The Highlight'), 1, 'selected video is a highlight');
  });

  click(this.page.videoFilter());
  click(this.page.videoFilter('All Videos'));

  andThen(() => {
    assert.equal(currentURL(), `/${CHANNEL_NAME}/videos/all`, 'redirected to all');
    assert.elementCount(this.page.video(), 2, 'back to all 2 videos');
  });
});

test('interactivity tracking', function (assert) {
  assert.expect(2);

  visit(`/${CHANNEL_NAME}/videos`);

  andThen(() => {
    initializeChat();
  });

  andThen(() => {
    assert.trackInteractivity('channel.videos.video-type');
    assert.trackBenchmarkEvent('complete_transition');
  });
});
