/* globals sendIRCMessage */

import { test } from 'qunit';
import moduleForAcceptance from 'web-client/tests/helpers/module-for-acceptance';
import channelScenario from 'web-client/mirage/scenarios/channel';
import followerScenario from 'web-client/mirage/scenarios/follower';
import ChannelPage from 'web-client/tests/pages/channel';

let channelName = 'twitch';
let page;

moduleForAcceptance('Acceptance-Channel: host-mode', {
  beforeEach() {
    channelScenario(this.server, channelName);
    page = ChannelPage.create({ name: channelName });
  }
});

test('visiting channel page that starts hosting', function (assert) {
  assert.expect(3);

  /* 
   * You cannot host a channel with uppercase letters as they are lowercased
   * before the hostMode code makes the API request to :channel/ember
   */
  let hostedChannelName = 'hostedchannel';
  channelScenario(this.server, hostedChannelName);

  followerScenario(this.server);
  visit(page.url());

  sendIRCMessage({
    command: 'HOSTTARGET',
    hostTarget: channelName,
    target: hostedChannelName
  });
  andThen(function () {
    assert.equal(currentURL(), `/${channelName}`);
    assert.equal(currentRouteName(), 'channel.index.index');
    assert.elementText(
      page.hostModeMessage,
      new RegExp(`Hosting ${hostedChannelName}`),
      'host mode message is visible'
    );
  });
});
