import { test } from 'qunit';
import moduleForAcceptance from 'web-client/tests/helpers/module-for-acceptance';
import channelScenario from 'web-client/mirage/scenarios/channel';
import commerceScenario, {
  gameNoLongerForSaleScenario,
  updateChannelWithGame
} from 'web-client/mirage/scenarios/commerce';
import ChannelCommercePage from 'web-client/tests/pages/channel/commerce';

let channelName = 'twitch';

moduleForAcceptance('Acceptance-Commerce: commerce-on-channel', {
  beforeEach() {
    this.page = ChannelCommercePage.create({ name: channelName });
    this.channel = channelScenario(this.server, channelName);
    //TODO: Remove this once we've taken out the whitelisting requirement.
    this.owner.lookup('service:globals').set('cmrcChannelBoxReleased', true);
  }
});

test('visiting channel page with game that is NOT fuel-enabled shows nothing.', function (assert) {
  assert.expect(3);
  visit(this.page.url());

  andThen(() => {
    assert.equal(currentURL(), `/${channelName}`);
    assert.equal(currentRouteName(), 'channel.index.index');
    assert.ok(this.page.commerceBoxHidden(), 'Commerce Box is hidden');
  });
});

test('visiting channel page with game that is NO longer for sale shows.', function (assert) {
  let gameName = 'Cant buy this anymore';
  gameNoLongerForSaleScenario(this.server, gameName);
  updateChannelWithGame(this.server, this.channel, gameName);

  assert.expect(3);
  visit(this.page.url());

  andThen(() => {
    assert.equal(currentURL(), `/${channelName}`);
    assert.equal(currentRouteName(), 'channel.index.index');
    assert.ok(this.page.commerceBoxHidden(), 'Commerce Box is hidden');
  });
});

test('visiting channel page with game that is for-sale has a buy box.', function (assert) {
  let gameName = 'Buy all the things';
  commerceScenario(this.server, gameName);
  updateChannelWithGame(this.server, this.channel, gameName);

  assert.expect(4);
  visit(this.page.url());

  andThen(() => {
    assert.equal(currentURL(), `/${channelName}`);
    assert.equal(currentRouteName(), 'channel.index.index');
    assert.ok(this.page.commerceBoxShown(), 'Commerce Box is shown');
    assert.ok(this.page.buyBox(), 'Buy Box is on-page');
  });
});

test('(staff beta, not staff, not released) visiting channel page with game that is for-sale does not have a buy box. ', function (assert) {
  this.owner.lookup('service:globals').set('cmrcChannelBoxReleased', false);
  let gameName = 'Buy all the things';
  commerceScenario(this.server, gameName);
  updateChannelWithGame(this.server, this.channel, gameName);

  assert.expect(3);
  visit(this.page.url());

  andThen(() => {
    assert.equal(currentURL(), `/${channelName}`);
    assert.equal(currentRouteName(), 'channel.index.index');
    assert.ok(this.page.commerceBoxHidden(), 'Commerce Box is shown');
  });
});
