import { test } from 'qunit';
import moduleForAcceptance from '../../helpers/module-for-acceptance';
import CommunitiesPage from '../../pages/communities/index';

let page;
let communityName = 'twitch';

moduleForAcceptance('Acceptance | /communities/:communityName', {
  beforeEach() {
    page = CommunitiesPage.create({ name: communityName });
  }
});

test('tracks interactivity', function (assert) {
  assert.expect(2);

  visit(page.url());

  andThen(() => {
    assert.trackInteractivity('communities.community');
  });

  andThen(() => { // Run in a separate andThen() because this gets fired from a resolved promise
    assert.trackBenchmarkEvent('complete_transition');
  });
});
