import { test } from 'qunit';
import moduleForAcceptance from '../../helpers/module-for-acceptance';
import CommunitiesLogPage from '../../pages/communities/log';
import { stubLogin } from '../../helpers/stub-login';

let page;
let communityName = 'twitch';

moduleForAcceptance('Acceptance | /communities/:communityName/moderation/log', {
  beforeEach() {
    page = CommunitiesLogPage.create({ name: communityName });
    stubLogin();
  }
});

test('tracks interactivity', function (assert) {
  assert.expect(2);

  visit(page.url());

  andThen(() => {
    assert.trackInteractivity('communities.moderation-log');
  });

  andThen(() => { // Run in a separate andThen() because this gets fired from a resolved promise
    assert.trackBenchmarkEvent('complete_transition');
  });
});
