import { test } from 'qunit';
import moduleForAcceptance from '../../helpers/module-for-acceptance';
import CommunitiesSettingsPage from '../../pages/communities/settings';
import { stubLogin } from '../../helpers/stub-login';

let page;
let communityName = 'twitch';

moduleForAcceptance('Acceptance | /communities/:communityName/moderation/settings', {
  beforeEach() {
    page = CommunitiesSettingsPage.create({ name: communityName });
    stubLogin();
  }
});

test('tracks interactivity', function (assert) {
  assert.expect(2);

  visit(page.url());

  andThen(() => {
    assert.trackInteractivity('communities.moderation-settings');
  });

  andThen(() => { // Run in a separate andThen() because this gets fired from a resolved promise
    assert.trackBenchmarkEvent('complete_transition');
  });
});
