import { test } from 'qunit';
import moduleForAcceptance from 'web-client/tests/helpers/module-for-acceptance';
import DashboardPage from 'web-client/tests/pages/dashboards';
import dashboardScenario from 'web-client/mirage/scenarios/dashboards';
import { stubLogin } from 'web-client/tests/helpers/stub-login';
import MockAutohostService from 'web-client/tests/helpers/mock-autohost-service';

moduleForAcceptance('Acceptance | dashboards/index', {
  beforeEach() {
    this.page = DashboardPage.create();
    this.server.create('user', {
      name: 'riotgameseu',
      display_name: 'RiotGamesEU',
      logo: 'http://profile.png'
    });
    this.server.create('user', {
      name: 'fooman',
      display_name: 'FooMan',
      logo: 'http://profile.png'
    });

    this.owner.register('service:autohost', MockAutohostService);
  }
});

test('visiting /dashboards/index as channel owner', function(assert) {
  assert.expect(3);

  dashboardScenario(this.server);
  stubLogin();

  visit(this.page.url());

  andThen(() => {
    assert.equal(currentURL(), '/twitch/dashboard', 'URL is correct');
    assert.equal(currentRouteName(), 'dashboards.index', 'Used expected route');
    assert.ok(this.page.videoStats(), 'Video Stats tab is visible');
  });
});

test('visiting /dashboards/index as staff', function(assert) {
  assert.expect(3);

  dashboardScenario(this.server);
  stubLogin({ login: 'fooman', is_staff: true });

  visit(this.page.url());

  andThen(() => {
    assert.equal(currentURL(), '/twitch/dashboard', 'URL is correct');
    assert.equal(currentRouteName(), 'dashboards.index', 'Used expected route');
    assert.ok(this.page.videoStats(), 'Video Stats tab is visible');
  });
});

test('visiting /dashboards/index as admin', function(assert) {
  assert.expect(3);

  dashboardScenario(this.server);
  stubLogin({ login: 'fooman', is_admin: true });

  visit(this.page.url());

  andThen(() => {
    assert.equal(currentURL(), '/twitch/dashboard', 'URL is correct');
    assert.equal(currentRouteName(), 'dashboards.index', 'Used expected route');
    assert.ok(this.page.videoStats(), 'Video Stats tab is visible');
  });
});
