import { test } from 'qunit';
import moduleForAcceptance from 'web-client/tests/helpers/module-for-acceptance';
import RevenuePage from 'web-client/tests/pages/dashboards/revenue';
import dashboardScenario from 'web-client/mirage/scenarios/dashboards';
import { stubLogin } from 'web-client/tests/helpers/stub-login';
import moment from 'moment';
import MockAutohostService from 'web-client/tests/helpers/mock-autohost-service';

moduleForAcceptance('Acceptance | /dashboard/revenue', {
  beforeEach() {
    this.page = RevenuePage.create();
    this.server.create('user', {
      name: 'riotgameseu',
      display_name: 'RiotGamesEU',
      logo: 'http://profile.png'
    });
  }
});

test('visit as channel owner', function(assert) {
  assert.expect(9);

  let endDate = moment().format('MMM D, YYYY');
  let startDate = moment().subtract(1, 'month').format('MMM D, YYYY');

  dashboardScenario(this.server);
  stubLogin();

  visit(this.page.url());

  andThen(() => {
    assert.equal(currentURL(), '/twitch/dashboard/revenue', 'URL is correct');
    assert.equal(currentRouteName(), 'dashboards.revenue', 'Used expected route');

    assert.equal(find('.new-dashboard .balloon-wrapper:first button').text().trim(), 'Days', 'date-picker component rendered, Days is default');
    assert.equal(find('.js-datepicker-start').val(), startDate, 'datepicker start correct');
    assert.equal(find('.js-datepicker-end').val(), endDate, 'datepicker end correct');
    assert.equal(find('.new-dashboard .revHeader').length, 1, 'revenue totals is rendered');
    assert.equal(find('.new-dashboard .dataWrap--partnerRev canvas').length, 1, 'revenue graphs is rendered');
    assert.equal(find('.new-dashboard .dataWrap--partnerMisc h4:first').text().trim(), 'Subscriptions', 'Subscriptions count component rendered');
    assert.equal(find('.new-dashboard .teeHeader h4').text().trim(), 'Teespring Revenue', 'Teespring campaigns component rendered');
  });
});

test('visit rev dashboard as a staff member', function(assert) {
  assert.expect(2);

  dashboardScenario(this.server);
  stubLogin({ login: 'fooman', is_staff: true });

  visit(this.page.url());

  andThen(() => {
    assert.equal(currentURL(), '/twitch/dashboard/revenue', 'URL is correct');
    assert.equal(currentRouteName(), 'dashboards.revenue', 'Used expected route');
  });
});

test('visit rev dashboard as an admin', function(assert) {
  assert.expect(1);

  this.server.create('channel-ember-data', {
    name: 'fooman',
    display_name: 'FooMan'
  });

  this.server.create('channel-stream', {
    name: 'fooman'
  });

  this.server.create('channel', {
    name: 'fooman'
  });

  this.owner.register('service:autohost', MockAutohostService);
  dashboardScenario(this.server);
  stubLogin({ login: 'fooman', is_admin: true });

  visit(this.page.url());

  andThen(() => {
    assert.equal(currentURL(), '/fooman/dashboard', 'User rerouted to own dashboard');
  });
});

test('visit rev dashboard as a regular user', function(assert) {
  assert.expect(1);

  this.server.create('channel-ember-data', {
    name: 'fooman',
    display_name: 'FooMan'
  });

  this.server.create('channel-stream', {
    name: 'fooman'
  });

  this.server.create('channel', {
    name: 'fooman'
  });

  this.owner.register('service:autohost', MockAutohostService);
  dashboardScenario(this.server);
  stubLogin({ login: 'fooman' });

  visit(this.page.url());

  andThen(() => {
    assert.equal(currentURL(), '/fooman/dashboard', 'User rerouted to own dashboard');
  });
});
