import { test } from 'qunit';
import moduleForAcceptance from 'web-client/tests/helpers/module-for-acceptance';
import { stubLogin } from 'web-client/tests/helpers/stub-login';
import dashboardScenario from 'web-client/mirage/scenarios/dashboards';
import StreamKeyPage from 'web-client/tests/pages/dashboards/stream-key';
import MockAutohostService from 'web-client/tests/helpers/mock-autohost-service';

moduleForAcceptance('Acceptance | dashboard/stream-key', {
  beforeEach() {
    this.page = StreamKeyPage.create();
    dashboardScenario(this.server);
    this.server.create('user', {
      name: 'riotgameseu',
      display_name: 'RiotGamesEU',
      logo: 'http://profile.png'
    });
  }
});

test('visiting /dashboard/streamkey as owner', function(assert) {
  assert.expect(2);
  stubLogin();

  visit(this.page.url());

  andThen(() => {
    assert.equal(currentURL(), '/twitch/dashboard/streamkey', 'URL is correct');
    assert.equal(currentRouteName(), 'dashboards.stream-key', 'Route is correct');
  });
});

test('visiting /dashboard/streamkey as staff member', function(assert) {
  assert.expect(2);

  this.server.create('channel-ember-data', {
    name: 'fooman',
    display_name: 'FooMan'
  });

  this.server.create('channel-stream', {
    name: 'fooman'
  });

  this.server.create('channel', {
    name: 'fooman'
  });

  this.owner.register('service:autohost', MockAutohostService);
  stubLogin({ login: 'fooman', is_staff: true });

  visit(this.page.url());

  andThen(() => {
    assert.equal(currentURL(), '/fooman/dashboard', 'User rerouted to own dashboard');
    assert.equal(currentRouteName(), 'dashboards.index', 'Route is correct');
  });
});

test('visiting /dashboards/streamkey as an admin', function(assert) {
  assert.expect(2);

  this.server.create('channel-ember-data', {
    name: 'fooman',
    display_name: 'FooMan'
  });

  this.server.create('channel-stream', {
    name: 'fooman'
  });

  this.server.create('channel', {
    name: 'fooman'
  });

  this.owner.register('service:autohost', MockAutohostService);
  stubLogin({ login: 'fooman', is_admin: true });

  visit(this.page.url());

  andThen(() => {
    assert.equal(currentURL(), '/fooman/dashboard', 'User rerouted to own dashboard');
    assert.equal(currentRouteName(), 'dashboards.index', 'Route is correct');
  });
});

test('visiting /dashboards/streamkey as a regular user', function(assert) {
  assert.expect(2);

  this.server.create('channel-ember-data', {
    name: 'fooman',
    display_name: 'FooMan'
  });

  this.server.create('channel-stream', {
    name: 'fooman'
  });

  this.server.create('channel', {
    name: 'fooman'
  });

  this.owner.register('service:autohost', MockAutohostService);
  stubLogin({ login: 'fooman'});

  visit(this.page.url());

  andThen(() => {
    assert.equal(currentURL(), '/fooman/dashboard', 'User rerouted to own dashboard');
    assert.equal(currentRouteName(), 'dashboards.index', 'Route is correct');
  });
});
