import { test } from 'qunit';
import { skip } from 'qunit';
import moduleForAcceptance from 'web-client/tests/helpers/module-for-acceptance';
import subscriptionDashScenario from 'web-client/mirage/scenarios/subscription-dash';
import { CheerOnboardingPage } from 'web-client/tests/pages/dashboards/subscription-dash';
import { stubLogin } from 'web-client/tests/helpers/stub-login';
import MockGeoService from 'web-client/tests/helpers/mock-geo-service';
import RSVP from 'rsvp';
import { getBitsString } from 'web-client/tests/helpers/bits-string';

const TIMS_SUCCESS = 'success';
const name = 'twitch';

moduleForAcceptance('Acceptance | dashboard/subscription/cheer', {
  beforeEach() {
    this.setupServer = (options, bitsOverrides) => {
      options.royaltyTaxState = options.royaltyTaxState || TIMS_SUCCESS;

      subscriptionDashScenario(this.server, options, bitsOverrides);
      stubLogin({ login: options.name });

      this.owner.register('service:geo', MockGeoService.extend({
        getGeo: () => {
          return RSVP.resolve({
            geo: options.geo
          });
        }
      }));

      this.page = CheerOnboardingPage.create({ username: options.name });
    };
  }
});

test('Cannot sign bits Amendment when requires royalty tax action', function (assert) {
  assert.expect(1);

  let isBitsEnabled = true;
  let royaltyTaxState = 'pending';
  let options = { name, isBitsEnabled, royaltyTaxState };
  this.setupServer(options);

  visit(this.page.url());

  andThen(() => {
    assert.ok(
      find(this.page.bitsFormCheckbox()).prop('disabled'),
      "checkbox is disabled when requires royalty tax action"
    );
  });
});

test('Cannot sign bits Amendment when requires service tax action', function (assert) {
  assert.expect(1);

  let isBitsEnabled = true;
  let options = { name, isBitsEnabled };
  this.setupServer(options, { bitsChannelSettings: { has_services_record: false }});

  visit(this.page.url());

  andThen(() => {
    assert.ok(
      find(this.page.bitsFormCheckbox()).prop('disabled'),
      "checkbox is disabled when requires service tax action"
    );
  });
});


test('Can sign bits Amendment when bits enabled', function (assert) {
  assert.expect(3);

  let isBitsEnabled = true;
  let options = { name, isBitsEnabled };
  this.setupServer(options);

  visit(this.page.url());

  andThen(() => {
    assert.ok(
      find(this.page.bitsFormCheckbox()).length > 0,
      "bits amendment checkbox is on page when bits feature flag is enabled"
    );
  });

  click(this.page.bitsFormCheckbox());

  andThen(() => {
    assert.ok(
      find(this.page.confirmButton()).prop('disabled'),
      "button disabled before scrolling down"
    );

    this.page.scrollDown();
  });

  andThen(() => {
    assert.notOk(
      find(this.page.confirmButton()).prop('disabled'),
      "button no longer disabled after scrolling down"
    );
  });
});

test('Can see geo-specific disclaimer when in one of the global launch countries', function(assert) {
  assert.expect(1);

  let globalLaunchStringKey = 'bits_amendment_geo_disclaimer_confirmation_messaging';

  let isBitsEnabled = false;
  let geo = 'RU';
  let options = { name, isBitsEnabled, geo };
  this.setupServer(options);

  visit(this.page.url());

  andThen(() => {
    click(this.page.bitsFormCheckbox());
  });

  andThen(() => {
    this.page.scrollDown();
  });

  andThen(() => {
    click(this.page.confirmButton());
  });

  andThen(() => {
    assert.equal(
      find(this.page.contractAmendmentsMessaging()).prop('innerText'), getBitsString(globalLaunchStringKey),
      "special disclaimer is displayed to newly launched global partners signing the bits amendment"
    );
  });
});

skip('Cannot sign bits Amendment when already signed', function (assert) {
  assert.expect(1);

  let isBitsEnabled = true;
  let bitsAmendment = 'signed';
  let options = { name, isBitsEnabled, bits_amendment: bitsAmendment };
  this.setupServer(options);

  visit(this.page.url());

  andThen(() => {
    assert.ok(
      find(this.page.bitsFormCheckbox()).prop('disabled'),
      "checkbox is disabled when status is 'signed'"
    );
  });
});
