import { test } from 'qunit';
import moduleForAcceptance from 'web-client/tests/helpers/module-for-acceptance';
import subscriptionDashScenario from 'web-client/mirage/scenarios/subscription-dash';
import { ChatPerksPage } from 'web-client/tests/pages/dashboards/subscription-dash';
import { stubLogin } from 'web-client/tests/helpers/stub-login';

const USERNAME = 'twitch';

moduleForAcceptance('Acceptance | dashboard/subscription/chatperks', {
  beforeEach() {
    this.setupServer = (options) => {
      subscriptionDashScenario(this.server, options);
      this.page = ChatPerksPage.create({ username: options.name });
    };

    stubLogin({ login: USERNAME });
  }
});

test('visits /dashboard/subscription/chatperks and goes back to /dashboard/subscription index page', function (assert) {
  assert.expect(3);

  this.setupServer({ name: USERNAME });
  visit(this.page.url());

  andThen(() => {
    assert.equal(
      currentURL(),
      `/twitch/dashboard/subscription/chatperks`,
      `/twitch/dashboard/subscription/chatperks is visited`
    );

    assert.equal(
      find(this.page.pageTitle()).text().trim(),
      'Emoticon Code Prefix',
      'title of "Emoticon Code Prefix" is present'
    );
  });

  click(this.page.backToIndex());

  andThen(() => {
    assert.equal(
      currentURL(),
      `/twitch/dashboard/subscription`,
      `/twitch/dashboard/subscription is visited`
    );
  });
});

test('can select a Emoticon prefix', function(assert) {
  assert.expect(3);

  this.setupServer({name: USERNAME });

  let assertPrefix = (expected, label) => {
    andThen(() => {
      assert.equal(
        find(this.page.prefixPreview()).text().trim(),
        expected,
        label
      );
    });
  };

  visit(this.page.url());

  assertPrefix('prefixEmotecode', 'initial value');

  fillIn(this.page.prefixInput(), 'foo');
  assertPrefix('fooEmotecode', 'updated value');

  fillIn(this.page.prefixInput(), 'BAZ');
  assertPrefix('bazEmotecode', 'updated value with caps');
});
