import { test } from 'qunit';
import moduleForAcceptance from 'web-client/tests/helpers/module-for-acceptance';
import subscriptionDashScenario from 'web-client/mirage/scenarios/subscription-dash';
import { gameCommerceSigned } from 'web-client/mirage/scenarios/subscription-dash';
import { GameCommerceSettingsPage } from 'web-client/tests/pages/dashboards/subscription-dash';
import { stubLogin } from 'web-client/tests/helpers/stub-login';

const TIMS_SUCCESS = 'success';
const name = 'twitch';

moduleForAcceptance('Acceptance | dashboard/subscription/game_commerce', {
  features: ['game-commerce'],

  beforeEach() {
    this.setupServer = (options, bitsOverrides, isSigned) => {
      options.royaltyTaxState = options.royaltyTaxState || TIMS_SUCCESS;

      subscriptionDashScenario(this.server, options, bitsOverrides);
      stubLogin({ username: options.name });
      if (isSigned) {
        gameCommerceSigned(this.server);
      }

      this.page = GameCommerceSettingsPage.create({ username: options.name });
    };
  }
});

test('Cannot sign game commerce Amendment when requires royalty tax action', function (assert) {
  assert.expect(1);

  let royaltyTaxState = 'pending';
  let options = { name, royaltyTaxState };
  this.setupServer(options);
  visit(this.page.url());

  andThen(() => {
    assert.ok(
      find(this.page.gameCommerceFormCheckbox()).prop('disabled'),
      'checkbox is disabled when requires royalty tax action'
    );
  });
});

test('Cannot sign game commerce Amendment when requires service tax action', function (assert) {
  assert.expect(1);

  let options = { name };
  this.setupServer(options, { bitsChannelSettings: { has_services_record: false }});

  visit(this.page.url());

  andThen(() => {
    assert.ok(
      find(this.page.gameCommerceFormCheckbox()).prop('disabled'),
      'checkbox is disabled when requires service tax action'
    );
  });
});


test('Can sign game commerce Amendment', function (assert) {
  assert.expect(4);

  let options = { name };
  this.setupServer(options);

  visit(this.page.url());

  andThen(() => {
    assert.ok(
      find(this.page.gameCommerceFormCheckbox()).length > 0,
      'game commerce amendment checkbox is on page'
    );
    assert.equal(
      find(this.page.gameCommerceFormCheckbox()).prop('disabled'), false,
      'checkbox is not disabled'
    );
  });

  click(this.page.gameCommerceFormCheckbox());

  andThen(() => {
    assert.ok(
      find(this.page.confirmButton()).prop('disabled'),
      'button disabled before scrolling down'
    );

    this.page.scrollDown();
  });

  andThen(() => {
    assert.notOk(
      find(this.page.confirmButton()).prop('disabled'),
      'button no longer disabled after scrolling down'
    );
  });
});
