import { test } from 'qunit';
import moduleForAcceptance from 'web-client/tests/helpers/module-for-acceptance';
import subscriptionDashScenario from 'web-client/mirage/scenarios/subscription-dash';
import { PaymentsPage } from 'web-client/tests/pages/dashboards/subscription-dash';
import { stubLogin } from 'web-client/tests/helpers/stub-login';

const name = 'twitch';

moduleForAcceptance('Acceptance | dashboard/subscription/payments', {
  beforeEach() {
    this.setupServer = (options) => {
      subscriptionDashScenario(this.server, options);
      stubLogin({ login: options.name });

      this.page = PaymentsPage.create({ username: options.name });
    };
  }
});

test('visits /dashboard/subscription/payments and goes back to /dashboard/subscription index page', function (assert) {
  assert.expect(4);

  this.setupServer({ name });
  visit(this.page.url());

  andThen(() => {
    assert.equal(
      currentURL(),
      `/twitch/dashboard/subscription/payments`,
      `/twitch/dashboard/subscription/payments is visited`
    );

    assert.equal(
      find(this.page.pageTitle()).text().trim(),
      'Payments',
      'title of "Payments" is present'
    );
  });

  click(this.page.backToIndex());

  andThen(() => {
    assert.equal(
      currentURL(),
      `/twitch/dashboard/subscription`,
      `/twitch/dashboard/subscription is visited`
    );

    assert.equal(this.page.headTitle(), `${name}'s Dashboard - Twitch`);
  });
});

test('Can sign Net Payment Amendment', function (assert) {
  assert.expect(4);

  let netPaymentAmendment = 'unsigned';
  let options = { net_payment_amendment: netPaymentAmendment, name };
  this.setupServer(options);

  visit(this.page.url());
  click(this.page.netPaymentFormCheckbox());

  andThen(() => {
    assert.equal(
      find(this.page.contractAmendmentsMessaging()).text().trim(),
      'Please read and agree to the following amendment to your Content License Agreement with Twitch in order to accept Xsolla payments.',
      'request to agree is present'
    );

    assert.ok(find(this.page.confirmButton()).prop('disabled'), "button disabled before scrolling down");

    this.page.scrollDown();
  });

  andThen(() => {
    assert.notOk(find(this.page.confirmButton()).prop('disabled'), 'Button not disabled after scrolling down');
  });

  click(this.page.confirmButton());

  andThen(() => {
    assert.ok($('p.desc').text().trim().match(/You have accepted the Content License Agreement Subscription Revenue Amendment\./));
  });
});

test('Cannot sign already accepted Net Payment Amendment', function (assert) {
  assert.expect(1);

  let netPaymentAmendment = 'signed';
  let options = { net_payment_amendment: netPaymentAmendment, name };
  this.setupServer(options);

  visit(this.page.url());

  andThen(() => {
    assert.ok(
      find(this.page.netPaymentFormCheckbox()).prop('disabled'),
      "checkbox is disabled when status is 'signed'"
    );
  });
});

test('Cannot sign default accepted Net Payment Amendment', function (assert) {
  assert.expect(1);

  let netPaymentAmendment = 'accepted_by_default';
  let options = { net_payment_amendment: netPaymentAmendment, name };
  this.setupServer(options);

  visit(this.page.url());

  andThen(() => {
    assert.ok(
      find(this.page.netPaymentFormCheckbox()).prop('disabled'),
      "checkbox is disabled when status is 'accepted_by_default'"
    );
  });
});
