import { test } from 'qunit';
import { skip } from 'qunit';
import moduleForAcceptance from 'web-client/tests/helpers/module-for-acceptance';
import subscriptionDashScenario from 'web-client/mirage/scenarios/subscription-dash';
import { streamlineBountySigned } from 'web-client/mirage/scenarios/subscription-dash';
import { StreamlineBountyPage } from 'web-client/tests/pages/dashboards/subscription-dash';
import { stubLogin } from 'web-client/tests/helpers/stub-login';

const TIMS_SUCCESS = 'success';
const name = 'twitch';

moduleForAcceptance('Acceptance | dashboard/subscription/streamline', {
  beforeEach() {
    this.setupServer = (options, bitsOverrides, isSigned) => {
      options.royaltyTaxState = options.royaltyTaxState || TIMS_SUCCESS;

      subscriptionDashScenario(this.server, options, bitsOverrides);
      stubLogin({ username: options.name });
      if (isSigned) {
        streamlineBountySigned(this.server);
      }

      this.page = StreamlineBountyPage.create({ username: options.name });
    };
  }
});

test('Cannot sign streamline Amendment when requires royalty tax action', function (assert) {
  assert.expect(1);

  let royaltyTaxState = 'pending';
  let options = { name, royaltyTaxState };
  this.setupServer(options);

  visit(this.page.url());

  andThen(() => {
    assert.ok(
      find(this.page.streamlineFormCheckbox()).prop('disabled'),
      'checkbox is disabled when requires royalty tax action'
    );
  });
});

test('Cannot sign streamline Amendment when requires service tax action', function (assert) {
  assert.expect(1);

  let options = { name };
  this.setupServer(options, { bitsChannelSettings: { has_services_record: false }});

  visit(this.page.url());

  andThen(() => {
    assert.ok(
      find(this.page.streamlineFormCheckbox()).prop('disabled'),
      'checkbox is disabled when requires service tax action'
    );
  });
});


test('Can sign Streamline Amendment', function (assert) {
  assert.expect(4);

  let options = { name };
  this.setupServer(options);

  visit(this.page.url());

  andThen(() => {
    assert.ok(
      find(this.page.streamlineFormCheckbox()).length > 0,
      'streamline amendment checkbox is on page'
    );
    assert.equal(
      find(this.page.streamlineFormCheckbox()).prop('disabled'), false,
      'checkbox is not disabled'
    );
  });

  click(this.page.streamlineFormCheckbox());

  andThen(() => {
    assert.ok(
      find(this.page.confirmButton()).prop('disabled'),
      'button disabled before scrolling down'
    );

    this.page.scrollDown();
  });

  andThen(() => {
    assert.notOk(
      find(this.page.confirmButton()).prop('disabled'),
      'button no longer disabled after scrolling down'
    );
  });
});

//TODO: Figure out how to over-mock the amendment_accepted w/o creating mirage model
skip('Cannot sign Streamline Amendment when already signed', function (assert) {
  assert.expect(1);

  let options = { name };
  this.setupServer(options, undefined, true);

  visit(this.page.url());

  andThen(() => {
    assert.ok(
      find(this.page.streamlineFormCheckbox()).prop('disabled'),
      'checkbox is disabled when status is "signed"'
    );
  });
});
