import { test } from 'qunit';
import moduleForAcceptance from 'web-client/tests/helpers/module-for-acceptance';
import subscriptionDashScenario from 'web-client/mirage/scenarios/subscription-dash';
import { TeespringPage } from 'web-client/tests/pages/dashboards/subscription-dash';
import { stubLogin } from 'web-client/tests/helpers/stub-login';

const USERNAME = 'twitch';

moduleForAcceptance('Acceptance | dashboard/subscription/teespring', {
  beforeEach() {
    this.setupServer = (options) => {
      subscriptionDashScenario(this.server, options);
      this.page = TeespringPage.create({ username: options.name });
    };

    stubLogin({ login: USERNAME });
  }
});

test('visits /dashboard/subscription/teespring and goes back to /dashboard/subscription index page', function (assert) {
  assert.expect(3);

  this.setupServer({ name: USERNAME });
  visit(this.page.url());

  andThen(() => {
    assert.equal(
      currentURL(),
      `/twitch/dashboard/subscription/teespring`,
      `/twitch/dashboard/subscription/teespring is visited`
    );

    assert.equal(
      find(this.page.pageTitle()).text().trim(),
      'Affiliate Options',
      'title of "Affiliate Options" is present'
    );
  });

  click(this.page.backToIndex());

  andThen(() => {
    assert.equal(
      currentURL(),
      `/twitch/dashboard/subscription`,
      `/twitch/dashboard/subscription is visited`
    );
  });
});
