import { test } from 'qunit';
import moduleForAcceptance from 'web-client/tests/helpers/module-for-acceptance';

import videoStatsScenario from 'web-client/mirage/scenarios/video-stats';
import VideoStatsPage from 'web-client/tests/pages/dashboards/video-stats';
import { stubLogin } from 'web-client/tests/helpers/stub-login';
import MockAutohostService from 'web-client/tests/helpers/mock-autohost-service';

moduleForAcceptance('Acceptance | dashboard/video-stats', {
  beforeEach() {
    let scenario = videoStatsScenario(this.server);
    this.channelOwner = scenario.owner;
    this.ownerName = this.channelOwner.name;
    this.page = VideoStatsPage.create({ ownerName: this.ownerName });
  }
});

test('visiting the video stats dashboard as the channel owner', function (assert) {
  assert.expect(1);

  stubLogin({ login: this.ownerName });
  visit(this.page.url());

  andThen(() => {
    assert.equal(currentURL(), `/${this.ownerName}/dashboard/video-stats`, 'URL is correct');
  });
});

test('visiting the video stats dashboard as staff for another channel', function (assert) {
  assert.expect(1);

  stubLogin({ login: 'fooman', is_staff: true });
  visit(this.page.url());

  andThen(() => {
    assert.equal(currentURL(), `/${this.ownerName}/dashboard/video-stats`, 'URL is correct');
  });
});

test('visiting the video stats dashboard as staff for another channel', function (assert) {
  assert.expect(1);

  stubLogin({ login: 'fooman', is_admin: true });
  visit(this.page.url());

  andThen(() => {
    assert.equal(currentURL(), `/${this.ownerName}/dashboard/video-stats`, 'URL is correct');
  });
});

test('visiting the video stats dashboard for another channel not as staff', function(assert) {
  assert.expect(1);

  this.server.create('channel-ember-data', {
    name: 'fooman',
    display_name: 'FooMan'
  });

  this.server.create('channel-stream', {
    name: 'fooman'
  });

  this.server.create('channel', {
    name: 'fooman'
  });

  this.server.create('user', {
    name: 'riotgameseu',
    display_name: 'RiotGamesEU',
    logo: 'http://profile.png'
  });

  this.owner.register('service:autohost', MockAutohostService);
  stubLogin({ login: 'fooman', is_staff: false });

  visit(this.page.url());

  andThen(() => {
    assert.equal(currentURL(), `/fooman/dashboard`, 'should re-direct back to the main dashboard view');
  });
});
