import { test } from 'qunit';
import moduleForAcceptance from 'web-client/tests/helpers/module-for-acceptance';

import VideoStatsDetailsPage from 'web-client/tests/pages/dashboards/video-stats/details';
import dashboardScenario from 'web-client/mirage/scenarios/dashboards';
import { stubLogin } from 'web-client/tests/helpers/stub-login';

const USERNAME = 'twitch';

moduleForAcceptance('Acceptance | dashboards/video-stats/details', {
  beforeEach() {
    this.page = VideoStatsDetailsPage.create({ username: USERNAME });

    let user = dashboardScenario(this.server);
    stubLogin({
      id: user._id,
      login: user.name,
      is_staff: true
    });
  }
});

test('visiting the Video Stats Details page', function (assert) {
  assert.expect(2);

  visit(this.page.url());

  andThen(() => {
    assert.equal(currentURL(), `/${USERNAME}/dashboard/video-stats/details`, 'transitioned');
    assert.equal(currentRouteName(), 'dashboards.video-stats.details');
  });
});

test('clicking the Overview tab', function (assert) {
  assert.expect(2);

  visit(this.page.url());
  click("a:contains('Overview')");

  andThen(() => {
    assert.equal(currentURL(), `/${USERNAME}/dashboard/video-stats`, 'transitioned');
    assert.equal(currentRouteName(), 'dashboards.video-stats.overview');
  });
});
