import { test } from 'qunit';
import moduleForAcceptance from 'web-client/tests/helpers/module-for-acceptance';

import VideoStatsPage from 'web-client/tests/pages/dashboards/video-stats';
import dashboardScenario from 'web-client/mirage/scenarios/dashboards';
import { stubLogin } from 'web-client/tests/helpers/stub-login';

const USERNAME = 'twitch';

moduleForAcceptance('Acceptance | dashboards/video-stats/overview', {
  beforeEach() {
    this.page = VideoStatsPage.create({ username: USERNAME });

    let user = dashboardScenario(this.server);
    stubLogin({
      id: user._id,
      login: user.name,
      is_staff: true
    });
  }
});

test('visiting the Overview page', function (assert) {
  assert.expect(2);

  visit(this.page.url());

  andThen(() => {
    assert.equal(currentURL(), `/${USERNAME}/dashboard/video-stats`, 'should be at the right URL');
    assert.equal(currentRouteName(), 'dashboards.video-stats.overview', 'should be using the right route');
  });
});

test('clicking the Details tab', function (assert) {
  assert.expect(2);

  visit(this.page.url());
  click("a:contains('Details')");

  andThen(() => {
    assert.equal(currentURL(), `/${USERNAME}/dashboard/video-stats/details`, 'should be at the right URL');
    assert.equal(currentRouteName(), 'dashboards.video-stats.details', 'should be using the right route');
  });
});
