import { test } from 'qunit';
import moduleForAcceptance from 'web-client/tests/helpers/module-for-acceptance';

import VideoStatsVideoDetailsPage from 'web-client/tests/pages/dashboards/video-stats/video/details';
import videoStatsScenario from 'web-client/mirage/scenarios/video-stats';
import { stubLogin } from 'web-client/tests/helpers/stub-login';

moduleForAcceptance('Acceptance | dashboards/video-stats/video/details', {
  beforeEach() {
    this.dashboardOwner = stubLogin();
    let scenario = videoStatsScenario(this.server, { login: this.dashboardOwner.login });
    this.video = scenario.video;

    this.page = VideoStatsVideoDetailsPage.create({ channelName: this.dashboardOwner.name, videoId: this.video.id });
  }
});

test('visiting the Video Stats Details page', function (assert) {
  assert.expect(2);

  visit(this.page.url());

  andThen(() => {
    assert.equal(currentURL(), `/${this.dashboardOwner.name}/dashboard/video-stats/${this.video.id}/details`, 'transitioned');
    assert.equal(currentRouteName(), 'dashboards.video-stats.video.details');
  });
});

test('clicking the Overview tab', function (assert) {
  assert.expect(2);

  visit(this.page.url());
  click("a:contains('Overview')");

  andThen(() => {
    assert.equal(currentURL(), `/${this.dashboardOwner.name}/dashboard/video-stats/${this.video.id}`, 'transitioned');
    assert.equal(currentRouteName(), 'dashboards.video-stats.video.overview');
  });
});
